<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include(__DIR__ . '/includes/functions.php');
$static_url = dirname($_SERVER['SCRIPT_NAME']) . '/assets/';
include 'session_check.php';

// Configurações do arquivo de log 📁
$log_file = __DIR__ . '/api/connection_log.json';
$log_data = [];

// Carrega dados existentes do arquivo de log 📤
if (file_exists($log_file)) {
    $log_content = file_get_contents($log_file);
    $log_data = json_decode($log_content, true);
}

// Processamento do formulário 📝
$success_message = "";
$error_message = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST["update_message"])) {
        $new_message = trim($_POST["message"]);
        
        if (empty($new_message)) {
            $error_message = "⚠️ Por favor, insira uma mensagem válida.";
        } else {
            // Atualiza os dados do log ✏️
            $log_data = [
                "message" => $new_message,
                "new_message" => true,
                "timestamp" => date("Y-m-d H:i:s")
            ];
            
            // Salva no arquivo JSON 💾
            if (file_put_contents($log_file, json_encode($log_data, JSON_PRETTY_PRINT))) {
                $success_message = "✅ Mensagem atualizada com sucesso!";
            } else {
                $error_message = "❌ Erro ao salvar a mensagem. Verifique as permissões do arquivo.";
            }
        }
    }
    
    // Resetar flag de nova mensagem 🔄
    if (isset($_POST["reset_flag"])) {
        $log_data['new_message'] = false;
        if (file_put_contents($log_file, json_encode($log_data, JSON_PRETTY_PRINT))) {
            $success_message = "🔄 Flag de nova mensagem resetada com sucesso!";
        } else {
            $error_message = "❌ Erro ao resetar a flag. Verifique as permissões do arquivo.";
        }
    }
}

$page_title = "📝 Gerenciamento de Mensagens";

$page_content = '<div class="container mt-5">
    <div class="card mb-5 mb-xl-12">
        <div class="card-body py-12">
            <h2 class="mb-9">💬 Gerenciamento de Mensagens</h2>';

if (!empty($success_message)) {
    $page_content .= '<div class="alert alert-success" role="alert">' . htmlspecialchars($success_message) . '</div>';
}

if (!empty($error_message)) {
    $page_content .= '<div class="alert alert-danger" role="alert">' . htmlspecialchars($error_message) . '</div>';
}

$page_content .= '<div class="row mb-12">
                <div class="col-xl-12 mb-15 mb-xl-0 pe-5">
                    <h4 class="mb-0">✏️ Atualizar Mensagem</h4>
                    <p class="fs-6 fw-semibold text-gray-600 py-4 m-0">📢 Atualize a mensagem que será exibida no sistema.</p>
                    
                    <form method="POST" action="">
                        <div class="form-group">
                            <label for="message">📋 Nova Mensagem:</label>
                            <textarea 
                                class="form-control" 
                                name="message" 
                                id="message" 
                                rows="3" 
                                placeholder="💡 Digite sua mensagem aqui">' . (isset($log_data['message']) ? htmlspecialchars($log_data['message']) : '') . '</textarea>
                        </div>
                        
                        <div class="text-center mt-4">
                            <button type="submit" name="update_message" class="btn btn-primary me-2">
                                <i class="ki-outline ki-check fs-2 me-2"></i> Atualizar Mensagem
                            </button>
                            <button type="submit" name="reset_flag" class="btn btn-secondary">
                                <i class="ki-outline ki-reset fs-2 me-2"></i> Resetar Flag
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            
            <div class="row mt-5">
                <div class="col-xl-12">
                    <div class="notice d-flex bg-light-primary rounded border-primary border border-dashed p-6">
                        <i class="ki-outline ki-message-text-2 fs-2tx text-primary me-4"></i>
                        <div class="d-flex flex-stack flex-grow-1 flex-wrap flex-md-nowrap">
                            <div class="mb-3 mb-md-0 fw-semibold">
                                <h4 class="text-gray-900 fw-bold">📊 Status da Mensagem</h4>
                                <div class="fs-6 text-gray-700 pe-7">
                                    <p>📌 <strong>Mensagem:</strong> ' . (isset($log_data['message']) ? htmlspecialchars($log_data['message']) : 'Nenhuma mensagem definida') . '</p>
                                    <p>🏷️ <strong>Nova mensagem:</strong> ' . (isset($log_data['new_message']) ? ($log_data['new_message'] ? '✅ Sim' : '❌ Não') : '❓ Desconhecido') . '</p>
                                    <p>⏱️ <strong>Última atualização:</strong> ' . (isset($log_data['timestamp']) ? htmlspecialchars($log_data['timestamp']) : '⏳ Nunca') . '</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>';

include 'includes/layout.php';
?>